	/**********************************************************************************************
	* Replication code for online appendix of the paper "Bubbles and crises: The role of house prices and credit", Journal of Applied Econometrics
	*
	*
	* This code creates all tables and figures in the online appendix, as well as figure 4 in the paper. The 
	* individual unit root tests are calculated using an OxCode.
	* is created by running the code "main_appendix.do"
	***********************************************************************************************/ 
	
	
	** Define working directory 
	clear all
	set more off
	***********************************************************************************
	*** global 		main    "YOUR LOCAL PATH" ***
	***********************************************************************************

	global dataPath 	  "$main/Data"
	global outputTables   "$main/Tables"
	global outputFigures  "$main/Figures"
	global codePath       "$main/Do files"
	global outputPath     "$main/Output"

	
	***********************************************************************************************
	*      Panel unit root tests in Table A1 (individual tests calculated by an ox code)        **
	***********************************************************************************************

	do "$codePath/Table A1.do"  


	***********************************************************************************************
	*      Table B2        								     **
	***********************************************************************************************
	
	do "$codePath/Table B1.do"  
	 

	***********************************************************************************************
	**     Table C1           								     **
	***********************************************************************************************
    
	do "$codePath/Table C1.do"

	***********************************************************************************************
	**     Figure D1        								     **
	***********************************************************************************************
    
	do "$codePath/Figure D1.do"

	***********************************************************************************************
	*      Table E1        								     **
	***********************************************************************************************
	
	do "$codePath/Table E1.do"  
	

	***********************************************************************************************
	*      Table E2        								     **
	***********************************************************************************************
	
	do "$codePath/Table E2.do"  
	
	***********************************************************************************************
	**     Figure F1        								     **
	***********************************************************************************************
    
	do "$codePath/Figure F1.do"
	
	***********************************************************************************************
	*      Table F1        								     **
	***********************************************************************************************
	
	do "$codePath/Table F1.do"  
	
	***********************************************************************************************
	**     Figure F2        								     **
	***********************************************************************************************
    
	do "$codePath/Figure F2.do"
	
	
	
